
import gurobi

def solve_advertising_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="social_media_commercials", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="television_commercials", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize cost
    model.setObjective(30000*x + 50000*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x + 3*y >= 20, name="young_girls_constraint")
    model.addConstr(x + 7*y >= 30, name="middle_aged_women_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of social media commercials: {x.varValue}")
        print(f"Number of television commercials: {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_advertising_problem()
