
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition")

# Create variables
x = m.addVar(lb=0, name="milk")
y = m.addVar(lb=0, name="cheese")

# Set objective
m.setObjective(2*x + 4*y, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x + 8*y >= 100, "calcium")
m.addConstr(5*x + 6*y >= 80, "vitamin_d")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: {m.objVal}")
    print(f"Servings of milk: {x.x}")
    print(f"Servings of cheese: {y.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

