
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define variables
M = m.addVar(vtype=GRB.CONTINUOUS, name="Milk_Servings")
C = m.addVar(vtype=GRB.CONTINUOUS, name="Cheese_Servings")

# Set the objective function
m.setObjective(2*M + 4*C, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*M + 8*C >= 100, "Calcium_Requirement")
m.addConstr(5*M + 6*C >= 80, "VitaminD_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milk servings: {M.x}")
    print(f"Cheese servings: {C.x}")
    print(f"Total cost: ${2*M.x + 4*C.x:.2f}")
else:
    print("No optimal solution found")
