
import gurobi

def solve_patient_diet():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(lb=0, name="Milk")
    C = model.addVar(lb=0, name="Cheese")

    # Objective function: minimize cost
    model.setObjective(2 * M + 4 * C, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * M + 8 * C >= 100, name="Calcium_Requirement")
    model.addConstr(5 * M + 6 * C >= 80, name="VitaminD_Requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal servings of milk: {M.varValue}")
        print(f"Optimal servings of cheese: {C.varValue}")
        print(f"Optimal cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_patient_diet()
