
import gurobipy as gp

# Create a new model
model = gp.Model("DessertFactory")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="cakes")  # Number of cakes
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pies")   # Number of pies

# Set objective function
model.setObjective(4*x + 3*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x + 5*y <= 1000, "sugar_constraint")
model.addConstr(5*x + 3*y <= 1200, "flour_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Number of Cakes: {x.x:.2f}")
    print(f"Number of Pies: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

