
from gurobipy import *

# Create a new model
m = Model("Dessert_Factory")

# Define decision variables
x_c = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cakes")
x_p = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pies")

# Set the objective function
m.setObjective(4*x_c + 3*x_p, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x_c + 5*x_p <= 1000, "sugar_limit")
m.addConstr(5*x_c + 3*x_p <= 1200, "flour_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cakes: {x_c.x}")
    print(f"Pies: {x_p.x}")
    print(f"Revenue: ${4*x_c.x + 3*x_p.x}")
else:
    print("No optimal solution found")
