
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
cakes = model.addVar(lb=0, name="cakes", vtype=gurobi.GRB.CONTINUOUS)
pies = model.addVar(lb=0, name="pies", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(4 * cakes + 3 * pies, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(4 * cakes + 5 * pies <= 1000, name="sugar_constraint")
model.addConstr(5 * cakes + 3 * pies <= 1200, name="flour_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Cakes: {cakes.varValue:.2f}")
    print(f"Pies: {pies.varValue:.2f}")
    print(f"Revenue: {model.objVal:.2f}")
else:
    print("No optimal solution found")
