
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("paint_mix")

# Create variables
x = model.addVar(lb=0, ub=1, name="x") # Fraction of Egret paint
y = model.addVar(lb=0, ub=1, name="y") # Fraction of Crane paint

# Set objective function
model.setObjective(0.4 * x + 1.2 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(60 * x + 85 * y >= 70, "quality_constraint")
model.addConstr(x + y == 1, "fraction_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Egret Paint Fraction (x): {x.x:.2f}")
    print(f"Crane Paint Fraction (y): {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

