
from gurobipy import *

# Create a model
m = Model("Paint_Mix")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="Egret_Paint_Fraction")
y = m.addVar(vtype=GRB.CONTINUOUS, name="Crane_Paint_Fraction")

# Constraints: Quality constraint and mixture constraint
m.addConstr(60*x + 85*y >= 70, "Quality_Constraint")
m.addConstr(x + y == 1, "Mixture_Constraint")
m.addConstr(x >= 0, "Non_Negativity_Egret")
m.addConstr(y >= 0, "Non_Negativity_Crane")

# Objective function: Minimize cost
m.setObjective(0.40*x + 1.20*y, GRB.MINIMIZE)

# Solve the model
m.optimize()

# Print solution if found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Egret Paint Fraction: {x.x}")
    print(f"Crane Paint Fraction: {y.x}")
    print(f"Minimum Cost: {m.ObjVal}")
else:
    print("No optimal solution found")

