
import gurobi

def solve_paint_blend_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, ub=1, name="Egret_paint_fraction")
    y = model.addVar(lb=0, ub=1, name="Crane_paint_fraction")

    # Objective function: minimize cost
    model.setObjective(0.40 * x + 1.20 * y, gurobi.GRB.MINIMIZE)

    # Quality constraint: 60x + 85y >= 70
    model.addConstr(60 * x + 85 * y >= 70, name="Quality_constraint")

    # Fraction constraint: x + y == 1
    model.addConstr(x + y == 1, name="Fraction_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Egret paint fraction: {x.varValue}")
        print(f"Crane paint fraction: {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_paint_blend_problem()
