
import gurobipy as gp

# Create a new model
model = gp.Model("pen_optimization")

# Create decision variables
x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # Regular pens
x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # Premium pens

# Set objective function
model.setObjective(3*x1 + 8*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 100, "demand_regular")
model.addConstr(x2 <= 50, "demand_premium")
model.addConstr(x1 + x2 <= 75, "total_sales")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular pens (x1): {x1.x}")
    print(f"Number of premium pens (x2): {x2.x}")
    print(f"Maximum Profit: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

