
from gurobipy import *

# Create a new model
m = Model("Pen_Sales")

# Add variables: x1 for regular pens and x2 for premium pens
x1 = m.addVar(lb=0, ub=100, vtype=GRB.CONTINUOUS, name="Regular_Pens")
x2 = m.addVar(lb=0, ub=50, vtype=GRB.CONTINUOUS, name="Premium_Pens")

# Objective function: Maximize profit
m.setObjective(3*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 75, "Total_Pens_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Sell {x1.x} regular pens and {x2.x} premium pens.")
else:
    print("No optimal solution found.")

