
import gurobi

def solve_pen_store_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, ub=100, name="regular_pens")
    x2 = model.addVar(lb=0, ub=50, name="premium_pens")

    # Objective function: Maximize 3x1 + 8x2
    model.setObjective(3 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Constraint: x1 + x2 <= 75
    model.addConstr(x1 + x2 <= 75, name="total_pens")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${3 * x1.varValue + 8 * x2.varValue}")
    else:
        print("The model is infeasible.")

# Run the function
solve_pen_store_problem()
