
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ScooterProduction")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="foldable_scooters")  # foldable scooters
y = m.addVar(vtype=GRB.CONTINUOUS, name="electric_scooters")  # electric scooters

# Set objective function
m.setObjective(150 * x + 200 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5 * x + 3 * y <= 4000, "design_constraint")
m.addConstr(4 * x + 6 * y <= 5000, "engineering_constraint")
m.addConstr(x >= 0, "foldable_non_negativity")
m.addConstr(y >= 0, "electric_non_negativity")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Foldable Scooters: {x.x:.2f}")
    print(f"Electric Scooters: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

