
from gurobipy import *

# Create a new model
m = Model("Scooter_Production")

# Define the decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="foldable_scooters")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="electric_scooters")

# Set the objective function: Maximize profit
m.setObjective(150*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 3*x2 <= 4000, "design_team_hours")
m.addConstr(4*x1 + 6*x2 <= 5000, "engineering_team_hours")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective (Max Profit): {m.objVal}")
