
import gurobi

def solve_scooter_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="foldable_scooters", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="electric_scooters", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(150 * x + 200 * y, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1.5 * x + 3 * y <= 4000, name="design_team_constraint")
    model.addConstr(4 * x + 6 * y <= 5000, name="engineering_team_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_scooter_problem()
