
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("AnimalFeedMix")

# Create decision variables
x = model.addVar(lb=0, name="Oats_kg")
y = model.addVar(lb=0, name="SunflowerSeeds_kg")

# Set objective function
model.setObjective(50*x + 70*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(5*x + 10*y >= 250, "ProteinRequirement")
model.addConstr(16*x + 22*y >= 400, "FatRequirement")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Oats (kg): {x.x}")
    print(f"Sunflower Seeds (kg): {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

