
from gurobipy import *

# Create a new model
m = Model("Animal_Feed_Mixing")

# Define variables
x1 = m.addVar(lb=0, name="oats")  # Amount of oats in kg
x2 = m.addVar(lb=0, name="sunflower_seeds")  # Amount of sunflower seeds in kg

# Set the objective function: Minimize cost
m.setObjective(50*x1 + 70*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 10*x2 >= 250, name="protein_constraint")
m.addConstr(16*x1 + 22*x2 >= 400, name="fat_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oats: {x1.x} kg")
    print(f"Sunflower seeds: {x2.x} kg")
    print(f"Total cost: ${50*x1.x + 70*x2.x}")
else:
    print("No optimal solution found")
