
import gurobi

def solve_animal_feed_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="oats", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Amount of oats in kilograms
    y = model.addVar(name="sunflower_seeds", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Amount of sunflower seeds in kilograms

    # Define the objective function: Minimize the total cost
    model.setObjective(50 * x + 70 * y, gurobi.GRB.MINIMIZE)

    # Add the protein constraint: 5x + 10y >= 250
    model.addConstr(5 * x + 10 * y >= 250, name="protein_constraint")

    # Add the fat constraint: 16x + 22y >= 400
    model.addConstr(16 * x + 22 * y >= 400, name="fat_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Amount of oats: {x.varValue} kg")
        print(f"Amount of sunflower seeds: {y.varValue} kg")
        print(f"Total cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The model status is not optimal or infeasible.")

solve_animal_feed_problem()
