
import gurobipy as gp

# Create a new model
m = gp.Model("asset_allocation")

# Create variables
x1 = m.addVar(name="money_market")  # Investment in money market fund
x2 = m.addVar(name="foreign_bonds")  # Investment in foreign bonds

# Set objective function
m.setObjective(0.02 * x1 + 0.102 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 150000, "total_investment")
m.addConstr(x1 >= 60000, "min_money_market")
m.addConstr(x2 <= 60000, "max_foreign_bonds")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in money market: {x1.x}")
    print(f"Optimal investment in foreign bonds: {x2.x}")
    print(f"Optimal total return: {m.objVal}")
else:
    print("The model is infeasible or unbounded.")

