
import gurobipy as gp

# Create a new model
m = gp.Model("CautiousAssetInvestment")

# Define variables
x1 = m.addVar(name="money_market_fund", lb=0)
x2 = m.addVar(name="foreign_bonds", lb=0)

# Objective function: Maximize average return
m.setObjective(0.02*x1 + 0.102*x2, gp.GRB.MAXIMIZE)

# Total investment constraint
m.addConstr(x1 + x2 == 150000, name="total_investment")

# Minimum investment in money market fund
m.addConstr(x1 >= 0.4 * 150000, name="min_money_market_fund")

# Maximum investment in foreign bonds
m.addConstr(x2 <= 0.4 * 150000, name="max_foreign_bonds")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Investment in money market fund: ${x1.varValue:.2f}")
    print(f"Investment in foreign bonds: ${x2.varValue:.2f}")
    print(f"Optimal return: ${0.02*x1.varValue + 0.102*x2.varValue:.2f}")
else:
    print("No optimal solution found.")
