
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Optimization")

# Create variables
x1 = m.addVar(lb=0, name="Chocolate")
x2 = m.addVar(lb=0, name="Coffee")
x3 = m.addVar(lb=0, name="Peanut_Butter")
x4 = m.addVar(lb=0, name="Maple_Syrup")

# Set objective function
m.setObjective(0.05*x1 + 0.10*x2 + 0.07*x3 + 0.06*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 300000, "Total_Investment")
m.addConstr(x1 <= x4, "Chocolate_Investment")
m.addConstr(x2 <= x3, "Coffee_Investment")
m.addConstr(x4 <= 0.20 * 300000, "Maple_Syrup_Investment")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Chocolate Investment: ${x1.x:.2f}")
    print(f"Coffee Investment: ${x2.x:.2f}")
    print(f"Peanut Butter Investment: ${x3.x:.2f}")
    print(f"Maple Syrup Investment: ${x4.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

