
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x_c = model.addVar(name="chocolate", lb=0)
    x_co = model.addVar(name="coffee", lb=0)
    x_pb = model.addVar(name="peanut_butter", lb=0)
    x_ms = model.addVar(name="maple_syrup", lb=0)

    # Objective function
    model.setObjective(0.05 * x_c + 0.10 * x_co + 0.07 * x_pb + 0.06 * x_ms, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_c <= x_ms, name="chocolate_maple_syrup_constraint")
    model.addConstr(x_co <= x_pb, name="coffee_peanut_butter_constraint")
    model.addConstr(x_ms <= 0.20 * 300000, name="maple_syrup_limit_constraint")
    model.addConstr(x_c + x_co + x_pb + x_ms <= 300000, name="total_investment_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment amounts:")
        print(f"Chocolate: ${x_c.x:.2f}")
        print(f"Coffee: ${x_co.x:.2f}")
        print(f"Peanut Butter: ${x_pb.x:.2f}")
        print(f"Maple Syrup: ${x_ms.x:.2f}")
        print(f"Total return: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
