
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("laptop_production")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="regular_laptops")
y = m.addVar(vtype=GRB.CONTINUOUS, name="touchscreen_laptops")

# Set objective function
m.setObjective(200 * x + 300 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * x + 25 * y <= 3000, "manual_labor")
m.addConstr(10 * x + 20 * y <= 2000, "calibration")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Regular laptops: {x.x:.2f}")
    print(f"Touchscreen laptops: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

