
from gurobipy import *

# Create a new model
m = Model("Laptop_Production")

# Define variables
R = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Laptops", lb=0)
T = m.addVar(vtype=GRB.CONTINUOUS, name="Touchscreen_Laptops", lb=0)

# Objective function: Maximize profit
m.setObjective(200*R + 300*T, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*R + 25*T <= 3000, "Manual_Labor_Constraint")
m.addConstr(10*R + 20*T <= 2000, "Calibration_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {R.x:.0f} regular laptops and {T.x:.0f} touchscreen laptops.")
    print(f"Maximum Profit: ${200*R.x + 300*T.x:.2f}")
else:
    print("No optimal solution found")
