
import gurobi

def solve_laptop_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="Regular_Laptops")
    T = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="Touchscreen_Laptops")

    # Objective function: Maximize profit
    model.setObjective(200*R + 300*T, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*R + 25*T <= 3000, name="Manual_Labor_Constraint")
    model.addConstr(10*R + 20*T <= 2000, name="Calibration_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Regular Laptops = {R.varValue}, Touchscreen Laptops = {T.varValue}")
        print(f"Maximum profit: ${200*R.varValue + 300*T.varValue}")
    else:
        print("No optimal solution found.")

solve_laptop_production()
