
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_truck")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="burritos") # Number of burritos, integer
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="tacitos") # Number of tacitos, integer


# Set objective: Maximize revenue
m.setObjective(17*x + 12*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 30, "min_burritos")
m.addConstr(x <= 100, "max_burritos")
m.addConstr(y >= 20, "min_tacitos")
m.addConstr(y <= 150, "max_tacitos")
m.addConstr(x + y <= 250, "total_orders")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Number of Burritos: {x.x}")
    print(f"Number of Tacitos: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

