
from gurobipy import *

# Create a new model
m = Model("FoodTruckRevenue")

# Define the decision variables
B = m.addVar(lb=30, ub=100, vtype=GRB.INTEGER, name="Burritos")
T = m.addVar(lb=20, ub=150, vtype=GRB.INTEGER, name="Tacitos")

# Set the objective function to maximize revenue
m.setObjective(17*B + 12*T, GRB.MAXIMIZE)

# Add the constraint for total orders
m.addConstr(B + T <= 250, "Total Orders Constraint")

# Optimize the model
m.optimize()

# Print out the results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of burritos to sell: {B.x}")
    print(f"Optimal number of tacitos to sell: {T.x}")
    print(f"Maximum revenue achievable: ${17*B.x + 12*T.x:.2f}")
else:
    print("No optimal solution found")
