
import gurobi

def solve_food_truck_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    B = model.addVar(lb=30, ub=100, name="Burritos")
    T = model.addVar(lb=20, ub=150, name="Tacitos")

    # Objective function: Maximize revenue
    model.setObjective(17 * B + 12 * T, gurobi.GRB.MAXIMIZE)

    # Additional constraint: Total sales cannot exceed 250
    model.addConstraint(B + T <= 250)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Burritos to sell: {B.varValue}")
        print(f"Tacitos to sell: {T.varValue}")
        print(f"Max Revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

# Run the function
solve_food_truck_problem()
