
import gurobipy as gp

# Create a new model
model = gp.Model("Taco Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fish_tacos")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken_tacos")

# Set objective function
model.setObjective(6*x + 4*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 20, "min_fish")
model.addConstr(y >= 40, "min_chicken")
model.addConstr(x <= 50, "max_fish")
model.addConstr(y <= 60, "max_chicken")
model.addConstr(x + y <= 80, "total_tacos")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Fish Tacos: {x.x}")
    print(f"Chicken Tacos: {y.x}")
    print(f"Total Profit: ${model.objVal}")
else:
    print("No solution found.")

