
from gurobipy import *

# Create a model
m = Model("Taco Stand Profit Maximization")

# Define decision variables
x = m.addVar(vtype=GRB.INTEGER, name="Fish Tacos")
y = m.addVar(vtype=GRB.INTEGER, name="Chicken Tacos")

# Set the objective function to maximize profit
m.setObjective(6*x + 4*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 20, "Minimum Fish Tacos")
m.addConstr(y >= 40, "Minimum Chicken Tacos")
m.addConstr(x <= 50, "Maximum Fish Tacos")
m.addConstr(y <= 60, "Maximum Chicken Tacos")
m.addConstr(x + y <= 80, "Total Tacos Limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fish Tacos: {x.x}")
    print(f"Chicken Tacos: {y.x}")
    print(f"Total Profit: ${6*x.x + 4*y.x:.2f}")
else:
    print("No optimal solution found")
