
import gurobi

def solve_taco_stand_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=20, ub=50, name="fish_tacos")  # At least 20, at most 50
    y = model.addVar(lb=40, ub=60, name="chicken_tacos")  # At least 40, at most 60

    # Objective function: Maximize profit
    model.setObjective(6 * x + 4 * y, gurobi.GRB.MAXIMIZE)

    # Additional constraint: Total tacos cannot exceed 80
    model.addConstraint(x + y <= 80, name="total_tacos")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Fish tacos = {x.varValue}, Chicken tacos = {y.varValue}")
        print(f"Maximum profit: ${6 * x.varValue + 4 * y.varValue}")
    else:
        print("The model is infeasible.")

solve_taco_stand_problem()
