
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ramen_stock")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="large_packages") # Allowing fractional packages for now
y = m.addVar(vtype=GRB.CONTINUOUS, name="small_packages")

# Set objective function
m.setObjective(3*x + 0.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + y <= 2000, "budget")
m.addConstr(3*x + y <= 400, "shelf_space")
m.addConstr(3*y >= 7*x, "small_package_proportion")
m.addConstr(x >= 0, "nonneg_x")
m.addConstr(y >= 0, "nonneg_y")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal number of large packages: {x.x}")
    print(f"Optimal number of small packages: {y.x}")
    print(f"Optimal profit: {m.objVal}")

    # Round down to get integer solutions if needed
    print("\nInteger Solution:")
    print(f"Optimal number of large packages: {int(x.x)}")
    print(f"Optimal number of small packages: {int(y.x)}")
    print(f"Optimal profit (integer solution): {3*int(x.x) + 0.5*int(y.x)}")

