
from gurobipy import *

# Create a new model
m = Model("Ramen_Stocking")

# Define variables
L = m.addVar(vtype=GRB.INTEGER, name="Large_Packages")
S = m.addVar(vtype=GRB.INTEGER, name="Small_Packages")

# Set objective function: Maximize profit
m.setObjective(3*L + 0.5*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*L + S <= 2000, "Budget_Constraint")
m.addConstr(3*L + S <= 400, "Shelf_Space_Constraint")
m.addConstr(S >= (7/3)*L, "Small_Packages_Percentage_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Large Packages: {L.x}")
    print(f"Number of Small Packages: {S.x}")
    print(f"Max Profit: {3*L.x + 0.5*S.x}")
else:
    print("No optimal solution found")
