
import gurobipy as gp

# Create a new model
m = gp.Model("Ramen_Stock_Optimization")

# Decision variables
L = m.addVar(name="Large_Packages", lb=0, vtype=gp.GRB.INTEGER)
S = m.addVar(name="Small_Packages", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(3*L + 0.50*S, sense=gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(3*L + S <= 2000, name="Budget_Constraint")

# Shelf space constraint
m.addConstr(3*L + S <= 400, name="Shelf_Space_Constraint")

# Stock composition constraint: At least 70% small packages
m.addConstr(S >= 0.70*(L + S), name="Stock_Composition_Constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Large Packages = {L.varValue}, Small Packages = {S.varValue}")
    print(f"Max Profit: ${m.objVal:.2f}")
else:
    print("The model is infeasible.")
