
import gurobipy as gp

# Create a new model
model = gp.Model("Appliance_Repair")

# Create decision variables
f = model.addVar(vtype=gp.GRB.CONTINUOUS, name="fridges")
o = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ovens")

# Set objective function
model.setObjective(100*f + 125*o, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*f + 30*o <= 1000, "Inspection_Time")
model.addConstr(30*f + 15*o <= 800, "Fixing_Time")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of fridges to repair: {f.x}")
    print(f"Number of ovens to repair: {o.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

