
from gurobipy import *

# Create a new model
m = Model("Repairman_Optimization")

# Define the variables
F = m.addVar(lb=0, vtype=GRB.INTEGER, name="Number_of_Fridges")
O = m.addVar(lb=0, vtype=GRB.INTEGER, name="Number_of_Ovens")

# Set the objective function: maximize earnings
m.setObjective(100*F + 125*O, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*F + 30*O <= 1000, "Inspection_Time_Constraint")
m.addConstr(30*F + 15*O <= 800, "Fixing_Time_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Fridges: {F.x}")
    print(f"Number of Ovens: {O.x}")
    print(f"Maximum Earnings: ${100*F.x + 125*O.x}")
else:
    print("No optimal solution found. The model is infeasible or unbounded.")
