
import gurobi

def solve_repairman_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="fridges", lb=0, ub=None)
    y = model.addVar(name="ovens", lb=0, ub=None)

    # Add inspection time constraint
    model.addConstr(20*x + 30*y <= 1000, name="inspection_time")

    # Add fixing time constraint
    model.addConstr(30*x + 15*y <= 800, name="fixing_time")

    # Set the objective function
    model.setObjective(100*x + 125*y, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of fridges to fix: {x.x}")
        print(f"Number of ovens to fix: {y.x}")
        print(f"Total earnings: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_repairman_problem()
