
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("weight_gain")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pizzas")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="donuts")

# Set objective function
m.setObjective(4*x + 2*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(300*x + 200*y >= 3000, "calorie_constraint")
m.addConstr(10*x + 7*y >= 200, "fat_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of pizzas: {x.x:.2f}")
    print(f"Number of donuts: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

