
from gurobipy import *

# Create a new model
m = Model("Actor_Diet")

# Define the decision variables
pizzas = m.addVar(vtype=GRB.CONTINUOUS, name="pizzas")
donuts = m.addVar(vtype=GRB.CONTINUOUS, name="donuts")

# Set the objective function (minimize cost)
m.setObjective(4*pizzas + 2*donuts, GRB.MINIMIZE)

# Add constraints
m.addConstr(300*pizzas + 200*donuts >= 3000, "calorie_constraint")
m.addConstr(10*pizzas + 7*donuts >= 200, "fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pizzas: {pizzas.x}")
    print(f"Donuts: {donuts.x}")
    print(f"Total cost: ${4*pizzas.x + 2*donuts.x:.2f}")
else:
    print("No optimal solution found")
