
import gurobi

def solve_actor_diet():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(name="Pizzas", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    D = model.addVar(name="Donuts", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective: Minimize cost
    model.setObjective(4 * P + 2 * D, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(300 * P + 200 * D >= 3000, name="calories_constraint")
    model.addConstr(10 * P + 7 * D >= 200, name="fat_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objVal:.2f}")
        print(f"Pizzas: {P.x:.2f}")
        print(f"Donuts: {D.x:.2f}")
    else:
        print("No optimal solution found")

if __name__ == "__main__":
    solve_actor_diet()
