
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x = m.addVar(name="paper_investment")
y = m.addVar(name="glass_investment")

# Set the objective function
m.setObjective(0.02 * x + 0.05 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y == 300000, "total_investment")
m.addConstr(x >= 90000, "min_paper")
m.addConstr(y <= 150000, "max_glass")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in paper: ${x.x}")
    print(f"Optimal investment in glass: ${y.x}")
    print(f"Maximum return: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

