
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
x_p = m.addVar(name="paper_investment", lb=0)
x_g = m.addVar(name="glass_investment", lb=0)

# Objective function: Maximize return on investment
m.setObjective(0.02*x_p + 0.05*x_g, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_p + x_g == 300000, name="total_investment")
m.addConstr(x_p >= 0.3*300000, name="min_paper_investment")
m.addConstr(x_g <= 0.5*300000, name="max_glass_investment")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in paper industry: ${x_p.x:.2f}")
    print(f"Optimal investment in glass industry: ${x_g.x:.2f}")
    print(f"Maximum return on investment: ${m.objVal:.2f}")
else:
    print("Model is not optimal")
