
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="paper_investment", lb=0)
    y = model.addVar(name="glass_investment", lb=0)

    # Objective function: Maximize 0.02x + 0.05y
    model.setObjective(0.02 * x + 0.05 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 300000, name="total_investment")
    model.addConstr(x >= 0.3 * 300000, name="min_paper_investment")
    model.addConstr(y <= 0.5 * 300000, name="max_glass_investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in paper industry: ${x.varValue:.2f}")
        print(f"Optimal investment in glass industry: ${y.varValue:.2f}")
        print(f"Max return: ${0.02*x.varValue + 0.05*y.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
