
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("coffee_optimization")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="large_coffees") # Allowing fractional coffees for now
y = m.addVar(vtype=GRB.CONTINUOUS, name="small_coffees")

# Set objective function
m.setObjective(5*x + 3*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x + 8*y <= 1000, "coffee_beans")
m.addConstr(20*x + 15*y <= 1500, "milk")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large coffees: {x.x}")
    print(f"Number of small coffees: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

