
from gurobipy import *

# Create a new model
model = Model("Coffee Shop Optimization")

# Define the decision variables
L = model.addVar(vtype=GRB.CONTINUOUS, name="Large_Coffees", lb=0)
S = model.addVar(vtype=GRB.CONTINUOUS, name="Small_Coffees", lb=0)

# Set the objective function
model.setObjective(5*L + 3*S, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*L + 8*S <= 1000, "Coffee_Beans_Constraint")
model.addConstr(20*L + 15*S <= 1500, "Milk_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: L = {L.x}, S = {S.x}")
    print(f"Maximum profit: ${5*L.x + 3*S.x:.2f}")
else:
    print("No optimal solution found")
