
import gurobi

def coffee_shop_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(name="Large_Coffee", lb=0, ub=gurobi.GRB.INFINITY)
    S = model.addVar(name="Small_Coffee", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Maximize profit
    model.setObjective(5*L + 3*S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*L + 8*S <= 1000, name="Coffee_Beans_Constraint")
    model.addConstr(20*L + 15*S <= 1500, name="Milk_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Large Coffees = {L.varValue}, Small Coffees = {S.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    coffee_shop_optimization()
