
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Ticket_Optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="vehicle_tickets") # Number of vehicle tickets
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="passenger_tickets") # Number of passenger tickets

# Set objective function
m.setObjective(130*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "total_tickets")
m.addConstr(x >= 20, "min_vehicle_tickets")
m.addConstr(y >= 4*x, "passenger_vehicle_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of vehicle tickets: {x.x}")
    print(f"Number of passenger tickets: {y.x}")
else:
    print("Infeasible or unbounded")

