
from gurobipy import *

# Create a model
m = Model("Boat_Company_Profit")

# Define the decision variables
v = m.addVar(name='vehicle_tickets', vtype=GRB.INTEGER, lb=0)
p = m.addVar(name='passenger_tickets', vtype=GRB.INTEGER, lb=0)

# Add constraints
m.addConstr(v + p <= 200, name='total_tickets')
m.addConstr(v >= 20, name='min_vehicle_tickets')
m.addConstr(p >= 4 * v, name='passenger_to_vehicle_ratio')

# Objective function: Maximize profit
m.setObjective(130 * v + 60 * p, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Vehicle tickets to sell: {v.x}, Passenger tickets to sell: {p.x}")
    print(f"Maximum profit achievable: ${130 * v.x + 60 * p.x}")
else:
    print("No optimal solution found. The problem might be infeasible.")
