
import gurobi

def solve_boat_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    V = model.addVar(lb=0, name="Vehicles")
    P = model.addVar(lb=0, name="Passengers")

    # Objective function: Maximize profit
    model.setObjective(130 * V + 60 * P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(V + P <= 200, name="Total_Tickets")
    model.addConstr(V >= 20, name="Min_Vehicles")
    model.addConstr(P >= 4 * V, name="Passengers_vs_Vehicles")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Vehicles: {V.varValue}, Passengers: {P.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_boat_company_problem()
